/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen;

import ca.teamdman.sfm.client.examples.SFMExampleProgram;
import ca.teamdman.sfm.client.screen.SFMFontUtils;
import ca.teamdman.sfm.client.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class ExamplesScreen
extends Screen {
    private final BiConsumer<String, List<SFMExampleProgram>> CALLBACK;

    public ExamplesScreen(BiConsumer<String, List<SFMExampleProgram>> callback) {
        super((Component)LocalizationKeys.EXAMPLES_GUI_TITLE.getComponent());
        this.CALLBACK = callback;
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderTransparentBackground(graphics);
        this.renderTransparentBackground(graphics);
        this.renderTransparentBackground(graphics);
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        MutableComponent warning1 = LocalizationKeys.EXAMPLES_GUI_WARNING_1.getComponent();
        SFMFontUtils.draw(graphics, this.font, (Component)warning1, this.width / 2 - this.font.width((FormattedText)warning1) / 2, 20, 0xFFFFFF, false);
        MutableComponent warning2 = LocalizationKeys.EXAMPLES_GUI_WARNING_2.getComponent();
        SFMFontUtils.draw(graphics, this.font, (Component)warning2, this.width / 2 - this.font.width((FormattedText)warning2) / 2, 36, 0xFFFFFF, false);
    }

    protected void init() {
        super.init();
        List<SFMExampleProgram> sfmExamplePrograms = SFMExampleProgram.gatherAll();
        int buttonWidth = sfmExamplePrograms.stream().map(SFMExampleProgram::displayName).mapToInt(arg_0 -> ((Font)this.font).width(arg_0)).max().orElse(50) + 10;
        int buttonHeight = 16;
        int paddingX = 5;
        int paddingY = 1;
        int buttonsPerRow = this.width / (buttonWidth + paddingX);
        int rowWidth = (buttonWidth + paddingX) * Math.min(buttonsPerRow, sfmExamplePrograms.size());
        int marginX = (this.width - rowWidth) / 2;
        int buttonIndex = 0;
        for (SFMExampleProgram entry : sfmExamplePrograms) {
            int x = marginX + paddingX + buttonIndex % buttonsPerRow * (buttonWidth + paddingX);
            int y = 50 + buttonIndex / buttonsPerRow * (buttonHeight + paddingY);
            this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setText((Component)Component.literal((String)entry.displayName())).setOnPress(btn -> {
                this.onClose();
                this.CALLBACK.accept(entry.programString(), sfmExamplePrograms);
            }).setPosition(x, y).setSize(buttonWidth, buttonHeight).build());
            ++buttonIndex;
        }
    }
}

